/*
 * Decompiled with CFR 0.152.
 */
package eu.thesociety.DragonbornSR.DragonsRadioMod.Block.TileEntity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.thesociety.DragonbornSR.DragonsRadioMod.Block.BlockSpeaker;
import eu.thesociety.DragonbornSR.DragonsRadioMod.ClientProxy;
import eu.thesociety.DragonbornSR.DragonsRadioMod.PacketHandler;
import eu.thesociety.DragonbornSR.DragonsRadioMod.network.MessageTERadioBlock;
import eu.thesociety.DragonbornSR.DragonsRadioMod.player.MP3Player;
import eu.thesociety.DragonbornSR.DragonsRadioMod.util.Speaker;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityRadio
extends TileEntity {
    private static final long MAX_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    public boolean isPlaying = false;
    public String streamURL = "";
    public boolean blockExists = true;
    public float volume = 0.1f;
    public boolean listenToRedstone = false;
    public ArrayList<Speaker> speakers = new ArrayList();
    private MP3Player player = null;
    private World world;
    private boolean redstoneInput = false;
    private boolean scheduledRedstoneInput = false;
    private boolean scheduleRedstoneInput = false;
    private int th = 0;
    private int speakersCount = 0;
    private UUID lastPlayerId;
    private long lastAccessTime;

    public TileEntityRadio(World w) {
        this.world = w;
        if (this.isPlaying) {
            this.startStream();
        }
    }

    public TileEntityRadio() {
        if (this.isPlaying) {
            this.startStream();
        }
    }

    public void setLastPlayer(EntityPlayer player) {
        if (player == null) {
            this.lastPlayerId = null;
            this.lastAccessTime = 0L;
        } else {
            this.lastPlayerId = player.func_110124_au();
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    public UUID getLastPlayerId() {
        if (this.lastPlayerId == null) {
            return null;
        }
        if (System.currentTimeMillis() - this.lastAccessTime > MAX_WAIT_TIME) {
            this.lastPlayerId = null;
            this.lastAccessTime = 0L;
            return null;
        }
        return this.lastPlayerId;
    }

    public void deleted() {
        this.blockExists = false;
    }

    public void setWorld(World w) {
        this.world = w;
    }

    public void startStream() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (!ClientProxy.audioPlayersList.contains(this.player)) {
            this.isPlaying = true;
            if (side == Side.CLIENT) {
                this.player = new MP3Player(this.streamURL, this.world, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                ClientProxy.audioPlayersList.add(this.player);
            }
        }
    }

    public void stopStream() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (ClientProxy.audioPlayersList.contains(this.player)) {
            if (side == Side.CLIENT) {
                this.player.stop();
            }
            ClientProxy.audioPlayersList.remove(this.player);
            this.isPlaying = false;
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145843_s() {
        this.stopStream();
        super.func_145843_s();
    }

    public void func_145845_h() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            ++this.th;
            if (this.th >= 10) {
                this.th = 0;
                for (Speaker s : this.speakers) {
                    Block sb = this.func_145831_w().func_147439_a((int)s.x, (int)s.y, (int)s.z);
                    if (sb instanceof BlockSpeaker) continue;
                    if (!this.func_145831_w().func_72938_d((int)((int)s.x), (int)((int)s.z)).field_76636_d) break;
                    this.speakers.remove(s);
                    break;
                }
            }
            if (Minecraft.func_71410_x().field_71439_g != null && this.player != null && !this.func_145837_r()) {
                float vol = this.getClosest();
                if (vol > 10000.0f * this.volume) {
                    this.player.setVolume(0.0f);
                } else {
                    float v2 = 10000.0f / vol / 100.0f;
                    if (v2 > 1.0f) {
                        this.player.setVolume(1.0f * this.volume * this.volume);
                    } else {
                        this.player.setVolume(v2 * this.volume * this.volume);
                    }
                }
                if (vol == 0.0f) {
                    this.func_145843_s();
                }
            }
        } else {
            if (this.isPlaying()) {
                ++this.th;
                if (this.th >= 60) {
                    this.th = 0;
                    for (Speaker s : this.speakers) {
                        if (this.field_145850_b.func_147439_a((int)s.x, (int)s.y, (int)s.z) instanceof BlockSpeaker) continue;
                        if (!this.field_145850_b.func_72938_d((int)((int)s.x), (int)((int)s.z)).field_76636_d) break;
                        this.speakers.remove(s);
                        break;
                    }
                }
            }
            if (this.scheduleRedstoneInput) {
                if (!this.scheduledRedstoneInput && this.redstoneInput) {
                    this.isPlaying = !this.isPlaying;
                    PacketHandler.NETWORK.sendToAll((IMessage)new MessageTERadioBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145831_w(), this.streamURL, this.isPlaying, this.volume, 1));
                }
                this.redstoneInput = this.scheduledRedstoneInput;
                this.scheduleRedstoneInput = false;
                this.scheduledRedstoneInput = false;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.streamURL = nbt.func_74779_i("streamurl");
        this.volume = nbt.func_74760_g("volume");
        this.listenToRedstone = nbt.func_74767_n("input");
        this.redstoneInput = nbt.func_74767_n("lastInput");
        this.isPlaying = nbt.func_74767_n("lastState");
        this.speakersCount = nbt.func_74762_e("speakersCount");
        for (int i = 0; i < this.speakersCount; ++i) {
            double x = nbt.func_74769_h("speakerX" + i);
            double y = nbt.func_74769_h("speakerY" + i);
            double z = nbt.func_74769_h("speakerZ" + i);
            this.addSpeaker(this.func_145831_w(), x, y, z);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("streamurl", this.streamURL);
        nbt.func_74776_a("volume", this.volume);
        nbt.func_74757_a("input", this.listenToRedstone);
        nbt.func_74757_a("lastInput", this.redstoneInput);
        nbt.func_74757_a("lastState", this.isPlaying);
        nbt.func_74768_a("speakersCount", this.speakers.size());
        for (int i = 0; i < this.speakers.size(); ++i) {
            nbt.func_74780_a("speakerX" + i, this.speakers.get((int)i).x);
            nbt.func_74780_a("speakerY" + i, this.speakers.get((int)i).y);
            nbt.func_74780_a("speakerZ" + i, this.speakers.get((int)i).z);
        }
    }

    public Packet func_145844_m() {
        for (Speaker s : this.speakers) {
            PacketHandler.NETWORK.sendToDimension((IMessage)new MessageTERadioBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b, "", false, 1.0f, 15, s.x, s.y, s.z), this.func_145831_w().field_73011_w.field_76574_g);
        }
        int mode = 13;
        if (this.listenToRedstone) {
            mode = 14;
        }
        return PacketHandler.NETWORK.getPacketFrom((IMessage)new MessageTERadioBlock(this));
    }

    public boolean getListenRedstoneInput() {
        return this.listenToRedstone;
    }

    public void setRedstoneInput(boolean input) {
        if (input) {
            this.scheduledRedstoneInput = input;
        }
        this.scheduleRedstoneInput = true;
    }

    private boolean checkIfSpeakerExists(World w, int x, int y, int z) {
        return w.func_147439_a(x, y, z) instanceof BlockSpeaker;
    }

    public int addSpeaker(World w, double x, double y, double z) {
        if (this.speakers.size() >= 10) {
            return 1;
        }
        for (Speaker s : this.speakers) {
            if (!s.isSamePos((int)x, (int)y, (int)z)) continue;
            return 2;
        }
        this.speakers.add(new Speaker(x, y, z, w));
        return 0;
    }

    public int canAddSpeaker(World w, double x, double y, double z) {
        if (this.speakers.size() >= 10) {
            return 1;
        }
        for (Speaker s : this.speakers) {
            if (!s.isSamePos((int)x, (int)y, (int)z)) continue;
            return 2;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    private float getClosest() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        float closest = (float)this.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (!this.speakers.isEmpty()) {
            for (Speaker s : this.speakers) {
                float distance = (float)Math.pow(player.func_70011_f(s.x, s.y, s.z), 2.0);
                if (!(closest > distance)) continue;
                closest = distance;
            }
        }
        return closest;
    }
}

